*                                                                                  ;
 *    Reading in the 1968 PSID data                                                 ;
 *                                                                                  ;
 *            Karen Dynan 8/25/06                                                   ;
 *                                                                                  ;
 *    We read it all in and then output select variables to a flat                  ;
 *    file to be picked up by STATA.                                                ;
 *                                                                                  ;
 
libname psid 'F:\PSID' ;
filename rawdat 'F:\PSID\raw\fam68.raw' ;
 
 data one;
 
   infile 'F:\PSID\68FAM.DAT'  lrecl=748  missover;
   INPUT
   V1 1-3                 V2 4-8                 V3 9-12
   V4 13                  V5 14-18               V6 19-22
   V7 23                  V8 24-27               V9 28
   V10 29-32              V11 33                 V12 34-37
   V13 38                 V14 39-41              V15 42
   V16 43-46              V17 47                 V18 48-51
   V19 52                 V20 53-56              V21 57
   V22 58-61              V23 62                 V24 63-65
   V25 66                 V26 67-69              V27 70
   V28 71-74              V29 75                 V30 76
   V31 77-80              V32 81-85              V33 86-88
   V34 89                 V35 90-92              V36 93
   V37 94-97              V38 98                 V39 99-101
   V40 102                V41 103-105            V42 106
   V43 107-109            V44 110                V45 111-113
   V46 114                V47 115-118            V48 119
   V49 120-123            V50 124                V51 125-128
   V52 129                V53 130-133            V54 134
   V55 135-138            V56 139                V57 140-143
   V58 144                V59 145-148            V60 149
   V61 150-153            V62 154                V63 155-158
   V64 159                V65 160-163            V66 164
   V67 165-168            V68 169                V69 170-173
   V70 174                V71 175                V72 176-179
   V73 180-183            V74 184-188            V75 189-193
   V76 194-198            V77 199-203            V78 204-208
   V79 209-213            V80 214-218            V81 219-223
   V82 224-227            V83 228-232            V84 233-237
   V85 238                V86 239                V87 240
   V88 241                V89 242                V90 243
   V91 244                V92 245-247            V93 248-249
   V94 250-252            V95 253                V96 254
   V97 255-263            V98 264-265            V99 266
   V100 267-269           V101 270               V102 271
   V103 272               V104 273               V105 274
   V106 275               V107 276               V108 277
   V109 278               V110 279               V111 280
   V112 281               V113 282-283           V114 284
   V115 285-286           V116 287               V117 288-289
   V118 290-291           V119 292               V120 293
   V121 294               V122 295               V123 296
   V124 297               V125 298               V126 299
   V127 300               V128 301               V129 302
   V130 303               V131 304               V132 305-307
   V133 308-311           V134 312               V135 313-314
   V136 315               V137 316               V138 317-318
   V139 319               V140 320               V141 321
   V142 322               V143 323               V144 324-325
   V145 326-329           V146 330               V147 331
   V148 332               V149 333               V150 334
   V151 335               V152 336               V153 337
   V154 338               V155 339               V156 340
   V157 341               V158 342               V159 343
   V160 344               V161 345               V162 346
   V163 347               V164 348               V165 349
   V166 350               V167 351               V168 352
   V169 353               V170 354               V171 355
   V172 356               V173_1 357             V173_2 358
   V174 359               V175 360               V176 361
   V177_1 362             V177_2 363             V178 364
   V179 365               V180 366               V181 367
   V182 368               V183 369               V184 370
   V185 371               V186 372               V187 373
   V188 374-376           V189 377               V190 378
   V191 379               V192 380               V193 381
   V194 382               V195 383-384           V196 385
   V197 386               V198 387               V199 388
   V200 389               V201 390               V202 391
   V203 392               V204 393               V205 394
   V206 395               V207 396               V208 397
   V209 398               V210 399-401           V211 402
   V212 403               V213 404               V214 405
   V215 406               V216 407               V217 408
   V218 409               V219 410               V220 411
   V221 412               V222 413               V223 414
   V224 415               V225 416               V226 417
   V227 418               V228 419               V229 420-422
   V230 423               V231 424               V232 425
   V233 426               V234 427               V235 428
   V236 429               V237 430               V238 431-433
   V239 434               V240 435-436           V241 437
   V242 438               V243 439               V244 440
   V245 441               V246 442               V247 443
   V248 444               V249 445               V250 446
   V251 447               V252 448               V253 449
   V254 450               V255 451               V256 452
   V257 453               V258 454               V259 455
   V260 456               V261 457               V262 458
   V263 459               V264 460               V265 461
   V266 462               V267 463               V268 464
   V269 465               V270 466               V271 467
   V272 468               V273 469               V274 470
   V275 471               V276 472               V277 473
   V278 474               V279 475               V280 476
   V281 477               V282_1 478             V282_2 479
   V283 480               V284 481               V285 482
   V286 483               V287 484               V288 485
   V289 486               V290 487               V291 488
   V292 489               V293 490               V294 491
   V295 492               V296 493               V297 494
   V298 495               V299 496               V300 497
   V301 498               V302 499               V303 500
   V304 501               V305 502               V306 503
   V307 504               V308 505               V309 506
   V310 507               V311 508-509           V312 510
   V313 511               V314 512               V315 513
   V316 514               V317 515               V318 516
   V319 517               V320 518-521           V321 522
   V322 523-528           V323 529-534           V324 535-540
   V325 541-544 .2        V326 545-548 .2        V327 549-552 .2
   V328 553-558           V329 559-564           V330 565-570
   V331 571-575           V332 576-580           V333 581-586
   V334 587-591           V335 592-596           V336 597-599 .2
   V337 600-603 .2        V338 604-607 .2        V339 608
   V340 609               V341 610               V342 611
   V343 612               V344 613               V345 614
   V346 615               V347 616               V348 617
   V349 618               V350 619               V351 620
   V352 621               V353 622               V354 623
   V355 624               V356 625               V357 626-628
   V358 629               V359 630               V360 631
   V361 632               V362 633               V363 634
   V364 635               V365 636               V366 637
   V367 638               V368 639               V369 640
   V370 641-642           V371 643               V372 644
   V373 645-649           V374 650               V375 651
   V376 652               V377 653               V378 654
   V379 655               V380 656               V381 657
   V382 658-660 .1        V383 661               V384 662
   V385 663               V386 664               V387 665
   V388 666               V389 667               V390 668
   V391 669               V392 670               V393 671
   V394 672               V395 673               V396 674
   V397 675               V398 676               V399 677-680 .2
   V400 681-684 .2        V401 685-688 .2        V402 689-692 .2
   V403 693-696 .2        V404 697-700 .2        V405 701-704 .2
   V406 705-708 .2        V407 709               V408 710
   V409 711               V410 712               V411 713
   V412 714               V413 715               V414 716
   V415 717               V416 718               V417 719
   V418 720               V419 721               V420 722
   V421 723               V422 724               V423 725
   V424 726               V425 727               V426 728
   V427 729               V428 730               V429 731
   V430 732               V431 733               V432 734
   V433 735               V434 736               V435 737-739
   V436 740-742           V437 743-745           V438 746
   V439 747-748;

* SAS LABEL STATEMENT;

LABEL
   V1 = "STUDY NUMBER 768"
   V2 = "INTERVIEW NUMBER 68"
   V3 = "FAMILY NUMBER 1:6-9"
   V4 = "SUBFAMILY NUMBER 68 1:10"
   V5 = "HOUSE VALUE 1:11-15"
   V6 = "YRLY PROP TAXES 1:16-19"
   V7 = "ACCURACY OF PR TAX 1:20"
   V8 = "YRLY MDRT PAYTS 1:27-30"
   V9 = "ACCURACY OF MTG PTS 1:31"
   V10 = "YRLY RENT PAYTS 1:32-35"
   V11 = "ACCURACY RENT PTS 1:36"
   V12 = "YRLY RENT VALUE 1:37-40"
   V13 = "ACCURACY OF RNT VAL 1:41"
   V14 = "YRLY UTILITY PTS 1:42-44"
   V15 = "ACCURACY OF UTIL 1:45"
   V16 = "A+R DONE SELF 1:46-49"
   V17 = "ACCURACY OF A+R SLF 1:50"
   V18 = "YRLY A+R PAYTS 1:51-54"
   V19 = "ACCURACY OF A+R PT 1:55"
   V20 = "YRLY CAR INSUR 1:56-59"
   V21 = "ACCURACY OF CAR INS 1:60"
   V22 = "YRLY CAR PAYTS 1:61-64"
   V23 = "ACCURACY OF CAR PTS 1:65"
   V24 = "SAVD ON CAR REPR 1:66-68"
   V25 = "ACCURACY OF SVD CAR 1:69"
   V26 = "TIME ON CAR REPR 1:70-72"
   V27 = "ACCURCY OF TIME C.R.1:73"
   V28 = "OTHR PAYTS YRLY 1:74-77"
   V29 = "ACCURACY OF OTHR PT 1:78"
   V30 = "FAMILY SIZE 2:11"
   V31 = "YRLY FOOD STD. 2:12-15"
   V32 = "YRLY NEED STD 2:16-20"
   V33 = "YRLY ALCOHOL 2:21-23"
   V34 = "ACCURACY OF ALC 2:24"
   V35 = "YRLY CIG EXP 2:25-27"
   V36 = "ACCURCY OF CIG EXP 2:28"
   V37 = "YRLY FOOD BILL 2:29-32"
   V38 = "ACCURACY OF FOOD 2:33"
   V39 = "YRLY FOOD GROWN 2:34-36"
   V40 = "ACCURACY OF FD GRN 2:37"
   V41 = "YRLY SAVD SEWING 2:38-40"
   V42 = "ACCURACY OF SVD SEW 2:41"
   V43 = "YRLY FOOD ON JOB 2:42-44"
   V44 = "ACCURACY FOOD JOB 2:45"
   V45 = "YRLY FOOD STAMPS 2:46-48"
   V46 = "ACCURACY FOOD STPS 2:49"
   V47 = "YRLY HEADS HRS 3:11-14"
   V48 = "ACCURACY:HDS HRS 3:15"
   V49 = "HRS UNEMPL HEAD 3:16-19"
   V50 = "ACCURACY UNEMP HEAD 3:20"
   V51 = "HRS HEAD ILL 3:21-24"
   V52 = "ACCURACY HEAD ILL 3:25"
   V53 = "YRLY WIFE HRS 3:26-29"
   V54 = "ACCURACY WIFE HRS 3:30"
   V55 = "PD CHILD CARE$  3:31-34"
   V56 = "ACCURACY PD CARE 3:35"
   V57 = "FREE HELP HRS 3:36-39"
   V58 = "ACCURACY FREE HELP 3:40"
   V59 = "H& W HOUSEWORK 3:41-44"
   V60 = "ACCURACY H& W HSWK 3:45"
   V61 = "HRS HOME PRODON 3:46-49"
   V62 = "ACCURACY HOME PRODN 3:50"
   V63 = "OTHERS HSWK 3:51-54"
   V64 = "ACCURACY OTH HSWK 3:55"
   V65 = "YRLY H& W WK HRS 3:56-59"
   V66 = "ACCURACY H& W WK HRS 3:60"
   V67 = "1ST OTHR WORK HRS 3:61-6"
   V68 = "ACCURACY 1ST OTH WK 3:65"
   V69 = "2ND OTHR WORK HRS 3:66-6"
   V70 = "ACCURACY 2ND OTH WK 3;70"
   V71 = "NO OF MAJOR ADULTS 3:71"
   V72 = "TOT OTHR WRK HRS 3:72-75"
   V73 = "LEISURE HRS/M.A.3:76-79"
   V74 = "HDS LABOR INCOME 4:11-15"
   V75 = "WIFE LBR INCOME 4:16-20"
   V76 = "H& W TAXBL INCOME 4:21-25"
   V77 = "1ST OTHR TXL INC 4:26-30"
   V78 = "2ND OTHR TXL INC 4:31-35"
   V79 = "TOT OTHERS INC  4:36-40"
   V80 = "FAM TRANSFER INC 4:41-45"
   V81 = "FAM MONEY INC 4:46-50"
   V82 = "CONTRIB OUTS FU 4:51-54"
   V83 = "FAM INC TAX 4:55-59"
   V84 = "COST OF INCOME 4:60-64"
   V85 = "ACCURACY:HD L INC4:65"
   V86 = "ACCURACY:WIFE INC 4:66"
   V87 = "ACCURACY:H& W TINC 4:67"
   V88 = "ACCURACY:1ST OTH INC 4:6"
   V89 = "ACCURACY:2ND OTH INC4:69"
   V90 = "ACCURACY:TRANSF INC4:70"
   V91 = "ACCURACY CONTRIB 4:71"
   V92 = "SRC PR SAMPL UN 5:11-13"
   V93 = "STATE (68) 5:14-15"
   V94 = "COUNTY(68) 5:16-18"
   V95 = "SIZ LGST CTY PSU 5:19"
   V96 = "LOCAL OR CPS FU # 5:20"
   V97 = "INTRVWR SOC SEC 5:21-29"
   V98 = "INTRVWR INT NO 5:30-31"
   V99 = "DATE OF INTVW 5:32"
   V100 = "LNGTH OF INTVW 5:33-35"
   V101 = "WHEN MOVED IN 5:36"
   V102 = "HOW MANY ROOMS 5:37"
   V103 = "OWN OR RENT 5:38"
   V104 = "MORTGAGE? 5:39"
   V105 = "WHY FREE HOUSING 5:40"
   V106 = "WORK FOR HOUSING 5:41"
   V107 = "ADD OR REPAIRS 5:42"
   V108 = "WHAT A& R DONE 5:43"
   V109 = "A& R DONE SELF 5:44"
   V110 = "OWE ON A& R 5:45"
   V111 = "MIGHT MOVE 5:46"
   V112 = "WHY MIGHT MOVE 5:47"
   V113 = "NUMBER IN DU 5:48-49"
   V114 = "HHOLD COMPOSITION 5:50"
   V115 = "NUMBER IN FAMILY 5:51-52"
   V116 = "NO ADULTS IN FAM 5:53"
   V117 = "AGE OF HEAD 5:54-55"
   V118 = "AGE OF WIFE 5:56-57"
   V119 = "SEX OF HEAD 5:58"
   V120 = "AGE YOUNGST CHILD 5:59"
   V121 = "NR CHLDRN IN SCHOOL 5:60"
   V122 = "NR CHLDRN LVNG AWAY 5:61"
   V123 = "NR CHLDRN IN INSTIT 5:62"
   V124 = "RQD NO ROOMS 5:63"
   V125 = "NR CHLDRN 0-11GRDS 5:64"
   V126 = "NR CHLDRN 12GRDS 5:65"
   V127 = "NR CHLDRN 13GRDS 5:66"
   V128 = "NR MOVED IN 5:67"
   V129 = "WHO MOVED IN 5:68"
   V130 = "NR MOVED OUT 5:69"
   V131 = "WHO MOVED OUT 5:70"
   V132 = "CPS PR SAMPL UN 5:71-73"
   V133 = "CPS HOUSEHOLD NR 5:74-77"
   V134 = "CPS SEGMENT, PART 5:78"
   V135 = "CPS SEGMENT,REST 5:79-80"
   V136 = "LAST PTO MTG 6:11"
   V137 = "EDUC EXPT CHLDRN 6:12"
   V138 = "AGE HD 1ST CHLD 6:13-14"
   V139 = "NR CAR DRIVERS 6:15"
   V140 = "DIFFIC FR NO CAR 6:16"
   V141 = "WHAT DIFF NO CAR 6:17"
   V142 = "ADEQ PUB TRANSP 6:18"
   V143 = "NR CARS OWNED 6:19"
   V144 = "YR OF NEWST CAR 6:20-21"
   V145 = "VALUE OF CARS 6:22-25"
   V146 = "CONDITION BEST COR 6:26"
   V147 = "CONDITION WORST COR 6:27"
   V148 = "OWE ON CAR 6:28"
   V149 = "CAR INSURED 6:29"
   V150 = "NR PAYTS LEFT 6:30"
   V151 = "NR SETS OF PAYTS 6:31"
   V152 = "CAR HAVE SEAT BELTS 6:32"
   V153 = "SEAT BELTS FASTENED 6:33"
   V154 = "DO OWN CAR REPAIR 6:34"
   V155 = "KINDS OF CAR REPAIR 6:35"
   V156 = "AMT SAVD CAR REPAIR 6:36"
   V157 = "TIME ON CAR REPAIR 6:37"
   V158 = "MEDICAL INSURANCE 6:38"
   V159 = "SAVINGS 6:39"
   V160 = "1MONTHS INC SAVED 6:40"
   V161 = "2MO INC SVD 5YRS 6:41"
   V162 = "EAT OUT OFTEN 6:42"
   V163 = "SPEND EATING OUT 6:43"
   V164 = "MILK DELIVERED 6:44"
   V165 = "SPEND ON MILK DLVRD 6:45"
   V166 = "SPEND ON OTHR FOOD 6:46"
   V167 = "SPEND ON ALCOHOL 6:47"
   V168 = "ALCHL IN FOOD BILL 6:48"
   V169 = "NR CIGS SMOKED 6:49"
   V170 = "CIGS IN FOOD BILL 6:50"
   V171 = "1ST WAY KP FD BL DN 6:51"
   V172 = "2ND WAY KP FD BL DN 6:52"
   V173_1 = "WAYS KP FD BL DN 6:51-52 RESP 1"
   V173_2 = "WAYS KP FD BL DN 6:51-52 RESP 2"
   V174 = "HOW OFTN EAT TGTHR 6:53"
   V175 = "1ST WAY SV ON CLTHNG6:54"
   V176 = "2ND WAY SV ON CLTHNG6:55"
   V177_1 = "WAYS SV ON CLTHNG6:54-55 RESP 1"
   V177_2 = "WAYS SV ON CLTHNG6:54-55 RESP 2"
   V178 = "AMT SVD ON CLOTHING 6:56"
   V179 = "WHO AT INTERVIEW 6:57"
   V180 = "WHO RESPONDENT 6:58"
   V181 = "RACE 6:59"
   V182 = "NR OF CALLS 6:60"
   V183 = "HOW CLEAN DU 6:61"
   V184 = "READING MTL IN DU 6:62"
   V185 = "NR QSTNS REPEATED 6:63"
   V186 = "NR REPLIES REPEATED 6:64"
   V187 = "R DISFIGURED 6:65"
   V188 = "NEAREST SMSA 6:66-68"
   V189 = "MILES TO CNTR CITY 6:69"
   V190 = "TYPE STRUCTURE 6:70"
   V191 = "NEIGHBORHOOD LWST 6:71"
   V192 = "NEIGHBORHOOD HGHST 6:72"
   V193 = "PUBLIC HOUSING 6:73"
   V194 = "HOUSING DEFECTS 6:74"
   V195 = "WORD-SCORE 6:75-76"
   V196 = "WORKING NOW 7:11"
   V197 = "OCCUPATION 7:12"
   V198 = "SELF-EMPLOYED 7:13"
   V199 = "OWN DECISIONS IMPT 7:14"
   V200 = "HOW LONG EMPLYR 7:15"
   V201 = "HPND PREVC JOB 7:16"
   V202 = "PRSNT JOB BETTER 7:17"
   V203 = "NR EMPLYRS 10 YRS 7:18"
   V204 = "EVR MOVED FOR JOB 7:19"
   V205 = "EVR TURND DOWN JOB 7:20"
   V206 = "ABLE FIND STDY WK HR7:21"
   V207 = "HOW GOOD JOB TO MOVE7:22"
   V208 = "PLAN NEW JOB 7:23"
   V209 = "KIND NEW JOB 7:24"
   V210 = "MIGHT EARN NW JB7:25-27"
   V211 = "NEED ADDTL TRNG 7:28"
   V212 = "DOING ANYTHING NJB7:29"
   V213 = "LIKE TOLD WHAT DO 7:30"
   V214 = "TROUBLE GET OTHR JB 7:31"
   V215 = "ILLNESS-ACCIDENT 7:32"
   V216 = "DISABILITY 7:33"
   V217 = "LATE TO WORK 7:34"
   V218 = "SKIP WORK 7:35"
   V219 = "UNEMPLYD-STRIKE 7:36"
   V220 = "DAYS UNEMPL IN 68 7:37"
   V221 = "DAYS ILL OR UNABLE 7:38"
   V222 = "WEEKS VACATION H 7:39"
   V223 = "WEEKS WORKED 7:40"
   V224 = "STANDARD WEEK? 7:41"
   V225 = "HRS IN STD WEEK 7:42"
   V226 = "HRS OVERTIME 7:43"
   V227 = "OTHER JOBS HD 7:44"
   V228 = "OTHER OCCUP HD 7:45"
   V229 = "$ PER HR 2ND JOB 7:46-48"
   V230 = "CD HAVE WKD MORE 7:49"
   V231 = "WANTED MORE WORK 7:50"
   V232 = "CD HAVE WORKED LESS 7:51"
   V233 = "WANTED LESS WORK 7:52"
   V234 = "BKT TAXBL INC H& W 8V234"
   V235 = "NR PLACES NAME IN 7:54"
   V236 = "NR PLACES APPLIED 7:55"
   V237 = "JOBS NOT WORTH IT 7:56"
   V238 = "PAY ON BAD JOBS 7:57-59"
   V239 = "MARITAL STATUS 7:60"
   V240 = "AGE HD 1ST MAR 7:61-62"
   V241 = "HOW LONG WIDOWED 7:63"
   V242 = "HOW CHILD CDRE 7:64"
   V243 = "WIFES OCCUPATION 7:65"
   V244 = "WIFES WEEKS WKD 7:66"
   V245 = "WIFES HRS/WEEK 7:67"
   V246 = "WIFES EDUCATION 7:68"
   V247 = "HDS FIRST MARRIAGE 7:69"
   V248 = "EXPECT CHILDREN? 7:70"
   V249 = "GROSS RECTS FARM 8:11"
   V250 = "BUSINESS INC? 8:12"
   V251 = "HDS WAGES 8:13"
   V252 = "HEAD OVERTIME 8:14"
   V253 = "PROF PRAC INC H 8:15"
   V254 = "FARM& ROOMER INC H 8:16"
   V255 = "DIV& INT& RENT INC-H 8:17"
   V256 = "ADC& ADCU INC-H 8:18"
   V257 = "OTHER WELFARE-H 8:19"
   V258 = "SOC SECURITY-H 8:20"
   V259 = "OTHR PENSIONS H 8:21"
   V260 = "UNEMPL COM& WC 8:22"
   V261 = "ALIMONY 8:23"
   V262 = "HELP FR RELATIVES 8:24"
   V263 = "WIFE INCOME TYPE 8:25"
   V264 = "WIFE TOT INC 8:26"
   V265 = "NR OTH INC RECRS 8:27"
   V266 = "SETTLEMENT RECVD 8:28"
   V267 = "SOURCE OF SETTLMNT 8:29"
   V268 = "FOOD, CLOTH AS PAY 8:30"
   V269 = "FOOD, CLOTH FREE 8:31"
   V270 = "67 INCOME USUAL 8:32"
   V271 = "WHY 67 UNUSUAL 8:33"
   V272 = "INC VARY MONTHLY 8:34"
   V273 = "WHY INC VARIES 8:35"
   V274 = "BETTER OFF FIN 8:36"
   V275 = "EXPENSES UNUSUAL 8:37"
   V276 = "LIKELY CHANGES 8:38"
   V277 = "CHANGES FOR BETTER 8:39"
   V278 = "DEPENDENTS NOT HERE 8:40"
   V279 = "WOULD HELP REL MORE 8:41"
   V280 = "DO IN SPARE TIME 8:42"
   V281 = "2ND DO SPARE TIME 8:43"
   V282_1 = "BOTH USES OF TIME8:42-43 RESP 1"
   V282_2 = "BOTH USES OF TIME8:42-43 RESP 2"
   V283 = "NR OF TIME USES 8:44"
   V284 = "HOW OFTEN CHURCH 8:45"
   V285 = "TAKING COURSES 8:46"
   V286 = "HOURS/DAY TV 8:47"
   V287 = "HOW OFTEN NEWSP 8:48"
   V288 = "NR NEIGHBORS KNOWN 8:49"
   V289 = "RELATIVES NEAR 8:50"
   V290 = "HRS HELPING REL 8:51"
   V291 = "HELP FROM OUTSIDE 8:52"
   V292 = "HOW OFTEN CLUBS 8:53"
   V293 = "HOW OFTEN TAVERN 8:54"
   V294 = "UNION AND DUES 8:55"
   V295 = "FELT LIFE WORK OUT 8:56"
   V296 = "PLAN AHEAD 8:57"
   V297 = "CARRY OUT PLANS 8:58"
   V298 = "FINISH THINGS 8:59"
   V299 = "LIKE CHALLENGE 8:60"
   V300 = "SPEND OR SAVE 8:61"
   V301 = "JOB LIKE,OR MONEY 8:62"
   V302 = "SATISFIED WITHSELF 8:63"
   V303 = "HAVE LIMITATIONS 8:64"
   V304 = "GET ANGRY EASILY 8:65"
   V305 = "MATTER OTHERS THINK 8:66"
   V306 = "TRUST MOST OTHERS 8:67"
   V307 = "FIGURE WAYS MORE$  8:68"
   V308 = "THINK ABOUT FUTURE 8:69"
   V309 = "LIFE GETTING BETTER 8:70"
   V310 = "UNDESERVED GOOD 8:71"
   V311 = "WHERE H GREW UP 8:72-73"
   V312 = "H GREW UP FARM 8:74"
   V313 = "HEADS EDUCATION 8:75"
   V314 = "HD OTHER TRAINING 8:76"
   V315 = "HEAD A VETERAN 8:77"
   V316 = "NR SIBLINGS HEAD 8:78"
   V317 = "HD PARENTS POOR 8:79"
   V318 = "H FATHERS EDUCATION8:80"
   V319 = "ACCURACY OF MORTG 1:21"
   V320 = "IMPUTED RENT 1:22-25"
   V321 = "ACCURACY IMP RENT 1:26"
   V322 = "TOTAL REAL Y 8V322"
   V323 = "REAL NET Y 8V323"
   V324 = "REAL NET Y-HSNG 8V324"
   V325 = "MONEY Y/NEEDS 8V325"
   V326 = "REAL NET Y/NEEDS 8V326"
   V327 = "REAL NET Y-HSNG/FD 8V327"
   V328 = "W-O MONEY Y 8V328"
   V329 = "W-O REAL Y 8V329"
   V330 = "W-O REAL Y-HSNG 8V330"
   V331 = "CONTRACTUAL PAYTS 8V331"
   V332 = "TOTAL FIXED EXP 8V332"
   V333 = "UNCOMMITTED Y 8V333"
   V334 = "TOTAL FOOD CONS 8V334"
   V335 = "TOTAL FAMILY WORK 8V335"
   V336 = "FOOD CONS/FOOD STD 8V336"
   V337 = "HEAD HOURLY EARN   8V337"
   V338 = "WIFE HOURLY EARN   8V338"
   V339 = "BKT TOT MONEY Y 8V339"
   V340 = "BKT TOT REAL Y 8V340"
   V341 = "BKT NET REAL Y 8V341"
   V342 = "BK NET REAL Y-HSNG 8V342"
   V343 = "BKT W-O MONEY Y 8V343"
   V344 = "BKT W-O REAL NET Y 8V344"
   V345 = "BKT W-O-HOUSING 8V345"
   V346 = "BKT CONTRACT PYMTS 8V346"
   V347 = "BK TOTAL FIXED EXP 8V347"
   V348 = "BKT UNCOMMITTED Y 8V348"
   V349 = "BK TOTAL FOOD CONS 8V349"
   V350 = "BK TOT FAMILY WORK 8V350"
   V351 = "FOR BKT 325, SEE V407"
   V352 = "FOR BKT 326, SEE V408"
   V353 = "FOR BKT 327, SEE V410"
   V354 = "BKT FD CONS/FD STD 8V354"
   V355 = "BKT HEAD HRLY EARN 8V355"
   V356 = "BKT WIFE HRLY EARN 8V356"
   V357 = "LAG MARR-1ST CHILD 8V357"
   V358 = "BKT LAG MARR-CHILD 8V358"
   V359 = "RESERVE FUNDS 8V359"
   V360 = "SEX-MARITAL STATUS 8V360"
   V361 = "REGION NOW 8V361"
   V362 = "REGION GREW UP 8V362"
   V363 = "GEO. MOBILITY 8V363"
   V364 = "AV ACC OF DOLLARY 8V364"
   V365 = "AV ACC OF FINANCES 8V365"
   V366 = "AV ACC OF HOURS 8V366"
   V367 = "AV ACC NONDOLLARY 8V367"
   V368 = "BKT AGE OF HEAD 8V368"
   V369 = "BKT AGE OF WIFE 8V369"
   V370 = "MEAN AGE OF COUPLE 8V370"
   V371 = "BKT AGE OF COUPLE 8V371"
   V372 = "BK COUPLE AGE DIF 8V372"
   V373 = "VALUE/ROOM 8V373"
   V374 = "BKT VALUE/ROOM 8V374"
   V375 = "BKT VALUE OF CARS 8V375"
   V376 = "BKT WORD-PICTURE 8V376"
   V377 = "BKT EARN ELSEWHERE 8V377"
   V378 = "BKT PAY REFUSED 8V378"
   V379 = "AGE AT MARRIAGE 8V379"
   V380 = "AGE AT 1ST BIRTH 8V380"
   V381 = "ACTUAL-REQD ROOMS  8V381"
   V382 = "PERSON PER ROOM 8V382"
   V383 = "RACE AND SEX 8V383"
   V384 = "EMPLOYMENT PROBS 8V384"
   V385 = "BACKGROUND PROBS 8V385"
   V386 = "CURRENT HANDICAPS 8V386"
   V387 = "NEIGHBHOOD &  HOUSE 8V387"
   V388 = "SENSE OF EFFICACY 8V388"
   V389 = "TRUST IN OTHERS 8V389"
   V390 = "ASPIRATIONS EXPRD  8V390"
   V391 = "HORIZON EXPRESSED 8V391"
   V392 = "HORIZON SELF-REPRT 8V392"
   V393 = "CONNECTED TO HELP 8V393"
   V394 = "MONEY EARNING ACTS 8V394"
   V395 = "REAL EARNING ACTS 8V395"
   V396 = "ECONOMIZING 8V396"
   V397 = "RISK AVOIDANCE 8V397"
   V398 = "NUMBER OF CHILDREN 8V398"
   V399 = "SSA ECONOMY FX.7 8V399"
   V400 = "SSA ECONOMY FX.8 8V400"
   V401 = "SSA LOW COST FX.7 8V401"
   V402 = "SSA LOW COST FX.8 8V402"
   V403 = "SSA MOD ECON FX.7 8V403"
   V404 = "SSA MOD ECON FX.8 8V404"
   V405 = "SSA MOD LO FX.7 8V405"
   V406 = "SSA MOD LO FX.8 8V406"
   V407 = "BKT MONEY Y/NEEDS 8V407"
   V408 = "BKT NET Y/NEEDS 8V408"
   V409 = "BKT SSA ECON FX.7 8V409"
   V410 = "BKT NET Y-H/FOOD 8V410"
   V411 = "BKT PERSONS/ROOM 8V411"
   V412 = "UNSKILL TEMP LABOR 8V412"
   V413 = "TYPICAL WAGE       8V413"
   V414 = "UNEMPLOY RATE      8V414"
   V415 = "PUBLIC WELFARE     8V415"
   V416 = "SCHOOL EXPENDITURE 8V416"
   V417 = "P CHANGE IN EMPLOY 8V417"
   V418 = "R68 HOUSING QUAL 8V418"
   V419 = "REV68 EFFICACY 8V419"
   V420 = "R68 TRUST-HOSTILE 8V420"
   V421 = "WANTED WORK OR HAD 8V421"
   V422 = "NEW JOB DETAILS 8V422"
   V423 = "R68 AMBITION-ASPIR 8V423"
   V424 = "SAVE> 75 A+R 8V424"
   V425 = "SAVE> 75 OWN FOOD 8V425"
   V426 = "SAVE> 75 CAR RPR 8V426"
   V427 = "R68 REAL EARN ACTS 8V427"
   V428 = "SPENT< 150 ALCOH 8V428"
   V429 = "SPENT< 150 CIGS 8V429"
   V430 = "FREE HELP>100 HRS 8V430"
   V431 = "NO NEW CAR>65 8V431"
   V432 = "R68 ECONOMIZING 8V432"
   V433 = "MED INS OR FREE 8V433"
   V434 = "R68 RISK AVOIDANCE 8V434"
   V435 = "SQRT W-O MONY 8V435"
   V436 = "SQRT W-O REAL-V329 8V436"
   V437 = "SQRT W-O HSNG-V330 8V437"
   V438 = "WAGE 2ND JOB BKT 8V438"
   V439 = "1968 WEIGHT 8V439";

* USER-DEFINED MISSING VALUE RECODE TO SAS SYSMIS;

IF V82 GE 9999 THEN V82=.;
IF V100 GE 999 THEN V100=.;
IF V101 GE 9 THEN V101=.;
IF V102 GE 9 THEN V102=.;
IF V103 GE 9 THEN V103=.;
IF V104 GE 9 THEN V104=.;
IF V105 GE 9 THEN V105=.;
IF V106 GE 9 THEN V106=.;
IF V107 GE 9 THEN V107=.;
IF V108 GE 9 THEN V108=.;
IF V109 GE 9 THEN V109=.;
IF V110 GE 9 THEN V110=.;
IF V111 GE 9 THEN V111=.;
IF V112 GE 9 THEN V112=.;
IF V113 GE 99 THEN V113=.;
IF V115 GE 99 THEN V115=.;
IF V116 GE 9 THEN V116=.;
IF V117 GE 99 THEN V117=.;
IF V118 GE 99 THEN V118=.;
IF V119 GE 9 THEN V119=.;
IF V120 GE 9 THEN V120=.;
IF V121 GE 9 THEN V121=.;
IF V122 GE 9 THEN V122=.;
IF V123 GE 9 THEN V123=.;
IF V125 GE 9 THEN V125=.;
IF V126 GE 9 THEN V126=.;
IF V127 GE 9 THEN V127=.;
IF V128 GE 9 THEN V128=.;
IF V129 GE 9 THEN V129=.;
IF V130 GE 9 THEN V130=.;
IF V131 GE 9 THEN V131=.;
IF V132=0 THEN V132=.;
IF V133=0 THEN V133=.;
IF V134=0 THEN V134=.;
IF V135=0 THEN V135=.;
IF V136 GE 9 THEN V136=.;
IF V137 GE 9 THEN V137=.;
IF V138 GE 99 THEN V138=.;
IF V139 GE 9 THEN V139=.;
IF V140 GE 9 THEN V140=.;
IF V141 GE 9 THEN V141=.;
IF V142 GE 9 THEN V142=.;
IF V143 GE 9 THEN V143=.;
IF V144 GE 99 THEN V144=.;
IF V145 GE 9999 THEN V145=.;
IF V146 GE 9 THEN V146=.;
IF V147 GE 9 THEN V147=.;
IF V148 GE 9 THEN V148=.;
IF V149 GE 9 THEN V149=.;
IF V150 GE 9 THEN V150=.;
IF V151 GE 9 THEN V151=.;
IF V152 GE 9 THEN V152=.;
IF V153 GE 9 THEN V153=.;
IF V154 GE 9 THEN V154=.;
IF V155 GE 9 THEN V155=.;
IF V156 GE 9 THEN V156=.;
IF V157 GE 9 THEN V157=.;
IF V158 GE 9 THEN V158=.;
IF V159 GE 9 THEN V159=.;
IF V160 GE 9 THEN V160=.;
IF V161 GE 9 THEN V161=.;
IF V162 GE 9 THEN V162=.;
IF V163 GE 9 THEN V163=.;
IF V164 GE 9 THEN V164=.;
IF V165 GE 9 THEN V165=.;
IF V166 GE 9 THEN V166=.;
IF V167 GE 9 THEN V167=.;
IF V168 GE 9 THEN V168=.;
IF V169 GE 9 THEN V169=.;
IF V170 GE 9 THEN V170=.;
IF V171 GE 9 THEN V171=.;
IF V172 GE 9 THEN V172=.;
IF V173_1 GE 9 THEN V173_1=.;
IF V173_2 GE 9 THEN V173_2=.;
IF V174 GE 9 THEN V174=.;
IF V175 GE 9 THEN V175=.;
IF V176 GE 9 THEN V176=.;
IF V177_1 GE 9 THEN V177_1=.;
IF V177_2 GE 9 THEN V177_2=.;
IF V178 GE 9 THEN V178=.;
IF V179 GE 9 THEN V179=.;
IF V180 GE 9 THEN V180=.;
IF V181 GE 9 THEN V181=.;
IF V182 GE 9 THEN V182=.;
IF V183 GE 9 THEN V183=.;
IF V184 GE 9 THEN V184=.;
IF V185 GE 9 THEN V185=.;
IF V186 GE 9 THEN V186=.;
IF V187 GE 9 THEN V187=.;
IF V188 GE 999 THEN V188=.;
IF V189 GE 9 THEN V189=.;
IF V190 GE 9 THEN V190=.;
IF V191 GE 9 THEN V191=.;
IF V192 GE 9 THEN V192=.;
IF V193 GE 9 THEN V193=.;
IF V195 GE 98 THEN V195=.;
IF V198 GE 9 THEN V198=.;
IF V199 GE 9 THEN V199=.;
IF V200 GE 9 THEN V200=.;
IF V201 GE 9 THEN V201=.;
IF V202 GE 9 THEN V202=.;
IF V203 GE 9 THEN V203=.;
IF V204 GE 9 THEN V204=.;
IF V205 GE 9 THEN V205=.;
IF V206 GE 9 THEN V206=.;
IF V207 GE 9 THEN V207=.;
IF V208 GE 9 THEN V208=.;
IF V209 GE 9 THEN V209=.;
IF V210 GE 999 THEN V210=.;
IF V211 GE 9 THEN V211=.;
IF V212 GE 9 THEN V212=.;
IF V213 GE 9 THEN V213=.;
IF V214 GE 9 THEN V214=.;
IF V215 GE 9 THEN V215=.;
IF V216 GE 9 THEN V216=.;
IF V217 GE 9 THEN V217=.;
IF V218 GE 9 THEN V218=.;
IF V219 GE 9 THEN V219=.;
IF V220 GE 9 THEN V220=.;
IF V221 GE 9 THEN V221=.;
IF V222 GE 9 THEN V222=.;
IF V223 GE 9 THEN V223=.;
IF V224 GE 9 THEN V224=.;
IF V225 GE 9 THEN V225=.;
IF V226 GE 9 THEN V226=.;
IF V227 GE 9 THEN V227=.;
IF V228 GE 9 THEN V228=.;
IF V229 GE 999 THEN V229=.;
IF V230 GE 9 THEN V230=.;
IF V231 GE 9 THEN V231=.;
IF V232 GE 9 THEN V232=.;
IF V233 GE 9 THEN V233=.;
IF V235 GE 9 THEN V235=.;
IF V236 GE 9 THEN V236=.;
IF V237 GE 9 THEN V237=.;
IF V238 GE 999 THEN V238=.;
IF V239 GE 9 THEN V239=.;
IF V240 GE 99 THEN V240=.;
IF V241 GE 9 THEN V241=.;
IF V242 GE 9 THEN V242=.;
IF V244 GE 9 THEN V244=.;
IF V245 GE 9 THEN V245=.;
IF V246 GE 9 THEN V246=.;
IF V247 GE 9 THEN V247=.;
IF V248 GE 9 THEN V248=.;
IF V249 GE 9 THEN V249=.;
IF V250 GE 9 THEN V250=.;
IF V251 GE 9 THEN V251=.;
IF V252 GE 9 THEN V252=.;
IF V253 GE 9 THEN V253=.;
IF V254 GE 9 THEN V254=.;
IF V255 GE 9 THEN V255=.;
IF V256 GE 9 THEN V256=.;
IF V257 GE 9 THEN V257=.;
IF V258 GE 9 THEN V258=.;
IF V259 GE 9 THEN V259=.;
IF V260 GE 9 THEN V260=.;
IF V261 GE 9 THEN V261=.;
IF V262 GE 9 THEN V262=.;
IF V263 GE 9 THEN V263=.;
IF V264 GE 9 THEN V264=.;
IF V265 GE 9 THEN V265=.;
IF V266 GE 9 THEN V266=.;
IF V267 GE 9 THEN V267=.;
IF V268 GE 9 THEN V268=.;
IF V269 GE 9 THEN V269=.;
IF V270 GE 9 THEN V270=.;
IF V271 GE 9 THEN V271=.;
IF V272 GE 9 THEN V272=.;
IF V273 GE 9 THEN V273=.;
IF V274 GE 9 THEN V274=.;
IF V275 GE 9 THEN V275=.;
IF V276 GE 9 THEN V276=.;
IF V277 GE 9 THEN V277=.;
IF V278 GE 9 THEN V278=.;
IF V279 GE 9 THEN V279=.;
IF V280 GE 9 THEN V280=.;
IF V281 GE 9 THEN V281=.;
IF V282_1 GE 9 THEN V282_1=.;
IF V282_2 GE 9 THEN V282_2=.;
IF V283 GE 9 THEN V283=.;
IF V284 GE 9 THEN V284=.;
IF V285 GE 9 THEN V285=.;
IF V286 GE 9 THEN V286=.;
IF V287 GE 9 THEN V287=.;
IF V288 GE 9 THEN V288=.;
IF V289 GE 9 THEN V289=.;
IF V290 GE 9 THEN V290=.;
IF V291 GE 9 THEN V291=.;
IF V292 GE 9 THEN V292=.;
IF V293 GE 9 THEN V293=.;
IF V294 GE 9 THEN V294=.;
IF V295 GE 9 THEN V295=.;
IF V296 GE 9 THEN V296=.;
IF V297 GE 9 THEN V297=.;
IF V298 GE 9 THEN V298=.;
IF V299 GE 9 THEN V299=.;
IF V300 GE 9 THEN V300=.;
IF V301 GE 9 THEN V301=.;
IF V302 GE 9 THEN V302=.;
IF V303 GE 9 THEN V303=.;
IF V304 GE 9 THEN V304=.;
IF V305 GE 9 THEN V305=.;
IF V306 GE 9 THEN V306=.;
IF V307 GE 9 THEN V307=.;
IF V308 GE 9 THEN V308=.;
IF V309 GE 9 THEN V309=.;
IF V310 GE 9 THEN V310=.;
IF V311 GE 99 THEN V311=.;
IF V312 GE 9 THEN V312=.;
IF V313 GE 9 THEN V313=.;
IF V314 GE 9 THEN V314=.;
IF V315 GE 9 THEN V315=.;
IF V316 GE 9 THEN V316=.;
IF V317 GE 9 THEN V317=.;
IF V318 GE 9 THEN V318=.;
IF V322=999999 THEN V322=.;
IF V323=999999 THEN V323=.;
IF V324=999999 THEN V324=.;
IF V325=99.99 THEN V325=.;
IF V326=99.99 THEN V326=.;
IF V327=99.99 THEN V327=.;
IF V328=999999 THEN V328=.;
IF V329=999999 THEN V329=.;
IF V330=999999 THEN V330=.;
IF V331=99999 THEN V331=.;
IF V332=99999 THEN V332=.;
IF V333=999999 THEN V333=.;
IF V334=99999 THEN V334=.;
IF V335=99999 THEN V335=.;
IF V336=9.99 THEN V336=.;
IF V337=99.99 THEN V337=.;
IF V338=99.99 THEN V338=.;
IF V340=9 THEN V340=.;
IF V346=9 THEN V346=.;
IF V347=9 THEN V347=.;
IF V348=9 THEN V348=.;
IF V349=9 THEN V349=.;
IF V350=9 THEN V350=.;
IF V351=9 THEN V351=.;
IF V352=9 THEN V352=.;
IF V353=9 THEN V353=.;
IF V354=9 THEN V354=.;
IF V357 GE 999 THEN V357=.;
IF V358=9 THEN V358=.;
IF V359=9 THEN V359=.;
IF V360=9 THEN V360=.;
IF V361=9 THEN V361=.;
IF V362=9 THEN V362=.;
IF V363=9 THEN V363=.;
IF V368=9 THEN V368=.;
IF V369=9 THEN V369=.;
IF V373=99999 THEN V373=.;
IF V374=9 THEN V374=.;
IF V375=9 THEN V375=.;
IF V376=9 THEN V376=.;
IF V377=9 THEN V377=.;
IF V378=9 THEN V378=.;
IF V379=9 THEN V379=.;
IF V380=9 THEN V380=.;
IF V381=9 THEN V381=.;
IF V435=999 THEN V435=.;
IF V436=999 THEN V436=.;
IF V437=999 THEN V437=.;
IF V438=9 THEN V438=.;
 
file rawdat lrecl=748;
put    
v3
v5
v7
v10
v11
v14
v15
v31
v37
v38
v45
v46
v47
v48
v53
v54
v67
v74
v75
v76
v79
v81
v85
v86
v99
v103
v104
v115
v117
v118
v119
v143
v181
v196
v198
v201
v223
v225
v239
v244
v245
v246
v255
v266
v313
v361
v364
v439
;

 proc means;
 run; 
